REBOL [
    subject: "Edition des catgories"
    author: "Olivier Auverlot"
]

; lecture des paramtres transmis
var: make object! decode-cgi system/options/cgi/query-string

; construction de la barre de menu
print "Content-type: text/html^/"
print {
    <HTML>
    </HEAD>
        <TITLE>Cration/Edition des catgories</TITLE>
    </HEAD>
    <BODY>
}

print join {<A href="editscript.cgi?clescript=} [ 
    var/clescript {">Retour</A>} 
]
clecateg: to-integer var/clecateg
print {<A href="javascript: fiche.submit();">Valider</A>}

if clecateg <> 0 [
    ; si l'enregistrement existe dj, l'utilisateur
    ; doit pouvoir l'effacer
    print join {<A href=modifcateg.cgi?action=3&clecateg=} [ 
        clecateg "&clescript=" var/clescript ">Supprimer</A>" 
    ]
] 
print "<HR>"
; gnration du formulaire
print {<FORM name="fiche" method="POST" action="modifcateg.cgi">}
fiche: copy {
Nom de la catgorie:<BR>
<INPUT type="field" name="nom" value="-NOM-">
<HR>
}

db: open odbc://scripts
p: first db

; si l'enregistrement existe, on rcupre son nom
; dans la base
either clecateg <> 0 [
    insert p [ "SELECT categorie FROM categories WHERE cle=?" clecateg ]
    resultat: copy p
    replace fiche "-NOM-" resultat/1/1
    ; passage en mode dition
    print {<INPUT type="hidden" name="action" value="2">}   
] [
    ; sinon le champ est vide
    replace fiche "-NOM-" ""
    ; passage en mode cration
    print {<INPUT type="hidden" name="action" value="1">}  
]
print join {<INPUT type="hidden" name="clecateg" value="} [ 
    var/clecateg {">} 
]
print join {<INPUT type="hidden" name="clescript" value="} [ 
    var/clescript {">} 
]

; affichage du formulaire
print fiche
; fermeture du formulaire
print "</FORM>"

; Rcupration de la liste des catgories
insert p "SELECT * FROM categories WHERE cle <> 1 ORDER BY categorie ASC"
liste: copy p

; fermeture de la connexion vers la base de donnes
close p
close db

; Affichage de la liste
foreach ligne liste [
    print join {<A href=editcateg.cgi?clescript=} [
        var/clescript {&clecateg=} ligne/1 {>}
        ligne/2 {</A><BR>}
    ]
]

print "</BODY></HTML>"

